---
allowed-tools: Bash(git:*), Bash(tree:*), Bash(ls:*), Bash(grep:*), Bash(cat:*), Bash(find:*), mcp__github__*, mcp__pocketPick_*, mcp__jina_*, FileSystem
description: Plan and analyze code tasks with comprehensive project understanding
argument-hint: github ticket id | task description
model: claude-opus-4-1-20250805
---

Understand the code and requirements we are working on.

## Arguments

- Task and/or Github Ticket ID: This can be mix and match, user may provide both
  task description and github ticket ID or just one of them.

## Context and commands for project analysis

- Current directory: !`pwd`
- Project structure: !`tree -L 3 -I 'node_modules|.git'`

### Additional commands for git repositories (if applicable)

- Git status: !`git status 2>/dev/null || echo "Not a git repository"`
- Current branch:
  !`git branch --show-current 2>/dev/null || echo "Not a git repository"`
- Recent commits:
  !`git log --oneline -5 2>/dev/null || echo "Not a git repository"`
- Remote info: !`git remote -v 2>/dev/null || echo "Not a git repository"`
- Git files: !`git ls-files 2>/dev/null || echo "Not a git repository"`

## Execution Sequence

**Step 1: Understand the project structure**

- Understand the project structure first.

- Then read about the dependency file (like package.json, requirements.txt,
  go.mod etc.) to understand the entrypoints, dependencies and versions, common
  scripts used in the project.

- If the project uses makefile, read the makefile to understand the common
  commands used in the project.

**Step 2: Understand the requirements**

- If Github Ticket ID is provided in $ARGUMENT, Run `git remote -v` to
  understand the remote and owner of the git repo. And then use the Github MCP
  tool to fetch the ticket details. If github MCP tool is not available, use
  `gh` cli.

- If $ARGUMENT mentions about any additional task, COMBINE it with ticket
  details and consider this as a task to do.

- If the requirement contains any bugs, and it isn't obvious from reading the
  code about the bug, use **triage** agent carefully to triage the bug and
  understand what's happening. Pass the path of taskFindings file to triage
  agent so that it can write the triage report there.

- IMPORTANT: Use triage report as additional context for planning.

**Step 3: Intelligence Gathering**

- Use following MCP Servers when developer asks or mention specific keywords
  - Developer Memory: PocketPick
  - Latest versions/documentation → use Jina
  - For newer versions of tools → use Jina

**Step 4: Planning**

**Step 4.1: Creating the hub**

- Decide the directory name where you will write the taskFindings
  - Rule for naming: Consider the appropriate short name, Max 3 words in
    kebab-case
  - Consider if it's a new functionality or upgraded on top of an existing
    functionality
    - For Upgrades:
      - Consider existing documents as previous version
      - IMPORTANT: MOVE existing documents to appropriate versioned directory
        -e.g. taskNotes/existing-directory-name-in-kebab-case/v1
      - Write new documents in the
        taskNotes/existing-directory-name-in-kebab-case/v2

  - Keep following format for your plan.
    <PlanFormat>

  # Purpose

  A one liner high level purpose of the task

  ## Original Ask
  Exact original requirements verbatim

  ## Complexity and the reason behind it
  Complexity score out of 5 and reason to chose this score

  ## Architectural changes required

  If none required, simply state that, otherwise write architectural plan

  ## Backend changes required

  If none required, simply state that, otherwise write backend implementation
  plan

  ## Frontend changes required

  If none required, simply state that, otherwise write frontend implementation
  plan

  ## Acceptance Criteria

  Only applicable for tasks with complexity score >= 3

  ## Validation

  Write the high level description of what to test and how to test it,

  Including commands to run and verify the changes. For frontend, user steps.
  For backend: API Flows with cases

</PlanFormat>

- IMPORTANT FOR COMPLEXITY SCORES:
  - IMPORTANT: Follow these rules along with your own intelligence
    - Do not consider a simple fullstack task as complex just because it
      involves both frontend and backend.
    - Take your capabilities into account, if you are good at something (Like
      greenfield scaffolding), lower the complexity score.
    - Consider the complexity of verification into account. If something seems
      easy to develop but hard to verify, increase the complexity score, and
      vice versa.

  - For dependency upgrades, determine following factors for complexity score
    - Breaking changes from new version
    - New changes/features that gives us advantages over current implementation
    - Total changes required.

- With all the information, enter into plan mode. Think about the solution.

- Write the plan in
  `taskNotes/{relevant-directory-name-in-kebab-case}/taskFindings.md` before
  presenting it to the user

**Optional Step 6: Iteration**

- If user asks you to change the plan, read current taskFindings file, and
  consider this as an additional context when you are thinking about the plan.

- IMPORTANT: For user next step is alwyas `/startWork`, any messages from user
  before start work is iteration of plan.

- IMPORTANT: The absense of taskFinding should always be considered as fresh
  plan even though user meant iteration.

**EXIT**

- AS SOON AS YOU WRITE THE TASKFINDINGS FILE, Ask the user to review and provide
  feedback.

- When user confirms the plan, take up a funny personality and present a funny,
  made-up and relevant star wars quote.

- IMPORTANT: AVOID CREATING ANY TODO LIST, ASK USER TO INVOKE `/startWork`
  COMMAND TO START WORK.