---
allowed-tools: Bash(git:*), FileSystem, Bash(npm:*), Bash(yarn:*), Bash(build:*), Bash(test:*), Bash(lint:*)
description: Complete and finalize task work with validation and documentation updates
---

Confirm the code changes and documentation updates for a task

## Arguments

- Directory Name: This is the name of the directory or task where
  taskFindings.md file is located. This is used to understand the context of the
  task and where to write the findings.

- Work mode: Backend or others

## Context and files

### Check if in git repository

- Is git repo: !`test -d .git && echo "true" || echo "false"`

- Task context: @taskNotes/{ArgumentDirectoryName}/taskFindings.md
- Current commit: @taskNotes/{ArgumentDirectoryName}/currentCommitHash. Ignore
  this if you are not in git repository

## Steps

- Make sure the $ARGUMENTS pass the directory name, if not, ask user before
  proceeding

- Read the uncommitted changes, read Task Context if it exists.

- If it doesn't exists, Ask user to run `/codePlanner` claude slash command. As
  of now you don't have the ability to run the command yourself.

- If you are in git repository, Read current commit, and then get list and code
  changes between latest commit and currentCommit mentioned in the file. If not
  in git repository, check for any recent file changes. Read the code carefully,
  think and confirm if changed code satisfies the requirements or not.

- Try to build the codebase. And run other commands to verify the changes built
  successfully. If the commands are not provided, ask user to provide them one
  at a time before you proceed. If the command fails, consider that the code
  doesn't satisfy any requirements.

- If the changed code doesn't satisfy the requirements, or any of the above
  command fails, think hard what needs to be done in one shot to satisfy the
  requirements. And fix it till the code satisfies the requirements and all the
  commands run successfully.

- As the last step of the task, Make sure none of the documentation is missing
  or outdated. If anything is missing and outdated, update the documentation
  accordingly using a subagent. This includes README files, comments in the
  code, and any other relevant documentation.

- After that, invoke **qa-validator** agent.
  - For backend mode: Ask it to run integration test of latest change
  - For frontend mode: Ask it to test the site using browser mcp tools

- Commit any uncommitted files with a short, concise and useful commit message
  (only if in git repository).

- Once it's done running, check the output file.
  - For backend, it must be backend-validation.md file.
  - For frontend, it must be frontend-validation.md file.

- Read the files and think, are we ready to move to the next step? And based on
  it, think, be pragmatic and suggest the next step.
  - For backend, the next step should always be implementing frontend if there
    is a frontend task
  - For frontend, the next step should be releasing.

- IMPORTANT: Commit messages should not include any description.

- Push the code (only if in git repository).