# Test Generation Skill

## Description
Automatically generate unit tests for functions and classes based on their implementation.

## Instructions

When asked to generate tests:

1. Analyze the function/class signature
2. Identify edge cases and normal cases
3. Generate comprehensive test cases using the project's test framework
4. Include:
   - Happy path tests
   - Edge cases (null, empty, boundary values)
   - Error cases
   - Mock dependencies when needed

## Framework Detection

Auto-detect test framework from project:
- Jest (package.json has jest)
- Vitest (package.json has vitest)
- Pytest (requirements.txt has pytest)
- Go test (*.go files)

## Example Usage

```
Generate tests for the calculateTotal function in src/utils.ts
```

## Output

Generate complete test file with:
- Imports
- Test suite setup
- Individual test cases
- Teardown if needed
