---
name: pdf-processing
description: Extract text and tables from PDF files, fill forms, merge documents. Use when working with PDF files or when the user mentions PDFs, forms, or document extraction.
license: Apache-2.0
allowed_tools:
  - Read
  - Bash
  - Write
---

# PDF Processing Skill

## Overview
This skill provides comprehensive PDF manipulation capabilities using Python libraries.

## Instructions

### 1. Text Extraction
Use pdfplumber to extract text from PDFs:
```bash
pip install pdfplumber
python -c "import pdfplumber; pdf = pdfplumber.open('file.pdf'); print(pdf.pages[0].extract_text())"
```

### 2. Table Extraction
Use tabula-py for extracting tables:
```bash
pip install tabula-py
python -c "import tabula; df = tabula.read_pdf('file.pdf', pages='all'); print(df)"
```

### 3. Form Filling
Use PyPDF2 to fill form fields:
```bash
pip install PyPDF2
python -c "from PyPDF2 import PdfReader, PdfWriter; # Fill form logic here"
```

## Examples

**Extract text from first page:**
```
Read the PDF at /path/to/file.pdf and extract all text from the first page.
```

**Extract tables:**
```
Find all tables in report.pdf and convert them to CSV format.
```

## Advanced Features
See reference documentation for more details on advanced PDF operations.
